set more off
pause off
clear
macro drop _all
graph set window fontface "Times New Roman"
cd ""
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"
use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

gen Trim_Assetsgr_top = 0
gen Trim_Assetsgr_bottom = 0

sort cyear

by cyear: egen Threshold99 = pctile(RealSales) if RealSales ! = ., p(99)
by cyear: egen Threshold1 = pctile(RealSales) if RealSales ! = ., p(1)

replace Trim_Assetsgr_top = 1 if RealSales > Threshold99 & RealSales ! = .
replace Trim_Assetsgr_bottom = 1 if RealSales < Threshold1 & RealSales ! = .

drop	Threshold*

gen logrinvtq = log(invtq/(gva_pindex/100))*100

gen cate_var2 = .
replace cate_var2 = 1 if DivDummy == 1 // zero dividends
replace cate_var2 = 2 if DivDummy == 2 // paid dividends


cap drop cate_var1
gen cate_var1 = .
replace cate_var1 = 1 if spcsrc == "A" | spcsrc == "A+" | spcsrc == "A-" | spcsrc == "B+" | spcsrc == "B" // zero dividends last period
replace cate_var1 = 2 if   spcsrc == "B-" | spcsrc == "C" | spcsrc == "D"  // paid dividends last period

cap drop cate_var
gen cate_var =.
replace cate_var = 1 if cate_var2==1 & cate_var1 ==1 // high rating + no div
replace cate_var = 2 if cate_var2==1 & cate_var1 ==2 // low rating + no div
replace cate_var = 3 if cate_var2==2 & cate_var1 ==1 // high rating + pos div
replace cate_var = 4 if cate_var2==2 & cate_var1 ==2 // low rating + pos div


capture label drop catlabel 
label define catlabel 1 "High rating - No div" 2 "Low rating - No div" 3 "High rating - Pos div" 4 "Low rating - Pos div", add


global ncat = 4

capture macro drop nq
global nq = ${ncat}

capture label drop catlabel 

tab cate_var

label values cate_var catlabel 

rename GK_New2019 Extracted_MPShockE

label var Extracted_MPShockE "MP Shock (GK extended)"

sort gvkeyn cyear cquarter
xtset gvkeyn qdate

capture drop shock_var*
capture drop group_var*

local shock Extracted_MPShockE 

cap drop posit* negat*
gen positives = Extracted_MPShockE if gs1d > 0 & gs1d !=.
gen negatives = Extracted_MPShockE if gs1d < 0 & gs1d !=.

replace positives = 0 if positives ==.
replace negatives = 0 if negatives ==.

gen logTotEmp = log(TotEmp)*100

* ================================================================

**** RESPONSE VARIABLE, POLICY VARIABLE AND INSTRUMENT INTERACTIONS.

* ================================================================

global dependent lnempC lnRealSales   invratio //  //      

foreach y in $dependent {

preserve
capture macro drop response
global response `y' 

cap drop d$response
sort gvkeyn qdate
by gvkeyn: gen d$response = $response - L.$response


capture macro drop policy_variable
global policy_variable gs1d  


capture macro drop ppolicy_variable
global ppolicy_variable gs1dp  

capture macro drop pnolicy_variable
global npolicy_variable gs1dn  

capture macro drop instrument
global instrument Extracted_MPShockE 

capture macro drop ninstrument
global ninstrument negatives  

capture macro drop pinstrument
global pinstrument positives 

drop if DebtAssetRatio < 0
drop if LiquidityRatio < 0
drop if saleq < 0
drop if invratio < 0

sort gvkeyn qdate

drop if cyear < 1980
drop if cyear == 1980 & cquarter ==1 
drop if cyear == 1980 & cquarter ==2


drop if cyear >= 2020

do "${mainpath}/Do/DOUBLE HETEROGENEITY/82A.LP_doublecut_Table_Div_Credit.do" 

capture macro drop $response

restore


}

